<?php
session_start();
require('../fpdf/fpdf.php');
require('plantilla_general.php');
require '../../../conexion.php';
require_once('../../../include/sesiones.php');
$desde=$_GET['desde'];
$hasta=$_GET['hasta'];


$pdf=new PDF_MC_Table();
$pdf->AddPage();
$pdf->SetFont('Arial','',14);
$pdf->AliasNbPages();

$pdf->Cell(0,10,'COMPRAS DESDE '.$desde. ' HASTA ' .$hasta,0,1);
$pdf->SetFont('Arial','',7);
    
$total_compras=0;
$iva_global=0;
$total_global=0;

$sqliva=mysqli_query($con,"SELECT * from iva where empresa='$empresa' ") or die(mysqli_error($con)); 
while ($iva=mysqli_fetch_array($sqliva))
{
    $iva_porcentaje=$iva['iva_porcentaje']; //19
    $iva0_t=$iva_porcentaje/100; //0.19
    $ivaf_t=1+$iva0_t; //1.19

    $pdf->SetFillColor(255,90,0);
    $pdf->Cell(190,4,'IMPUESTO '.$iva_porcentaje.' %',1,0,'C',1);
    $pdf->Ln(); 

    $pdf->SetFillColor(235,225,215);
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(15,4,'CODIGO',1,0,'C',1);
    $pdf->Cell(80,4,'NOMBRE',1,0,'C',1);
    $pdf->Cell(15,4,'CANT',1,0,'C',1);
    $pdf->Cell(20,4,'PRECIO',1,0,'C',1);
    $pdf->Cell(10,4,'IMP %',1,0,'C',1);
    $pdf->Cell(15,4,'IMP $',1,0,'C',1);
    $pdf->Cell(15,4,'CARGO A',1,0,'C',1);
    $pdf->Cell(20,4,'TOTAL',1,0,'C',1);
    $pdf->Ln(); 

    $neto=0;
    $total_descuento=0;
    $total_iva=0;
    $sumador_articulos=0;
    $cargo_adicional=0;
    $total_retencion=0;
    $iva_global=0;
    $cargo_global=0;
    $total_cargo_adicional=0;

    $registros=mysqli_query($con,"SELECT *,sum(cc.comd_cantidad) as can,AVG(cc.comd_precio) as pc, AVG(cc.comd_flete) as flete FROM compras c, compra_detalle cc  where c.com_id=cc.compras_com_id and cc.comd_iva='$iva_porcentaje' and c.com_fecha BETWEEN '$desde' AND '$hasta' and c.empresa='$empresa' group by cc.comd_art_id,cc.comd_iva,cc.comd_flete") or die(mysqli_error($con));
    $result = mysqli_num_rows($registros);
    while ($rew=mysqli_fetch_array($registros))
    {

        $comd_referencia=$rew['comd_referencia'];
        $comd_nombre=$rew['comd_nombre'];
        $comd_cantidad=$rew['can'];
        $comd_precio=$rew['pc'];
        $comd_iva=$rew['comd_iva'];
        $precio_total=$comd_precio*$comd_cantidad;
        $iva=($precio_total*$comd_iva)/100;
        $neto+=$precio_total;//Sumador
        $comd_flete=$rew['flete'];
        $cargo_adicional=$comd_flete*$comd_cantidad;
        $sumador_articulos+=$precio_total;//Sumador
        $total_iva+=$iva;//Sumador
        $total_cargo_adicional+=$cargo_adicional;

        
        $pdf->SetFillColor(255,255,255);
        $pdf->SetFont('Arial','',7);
        $pdf->Cell(15,4,$comd_referencia,1,0,'C',1);
        $pdf->Cell(80,4,utf8_decode($comd_nombre),1,0,'C',1);
        $pdf->Cell(15,4,$comd_cantidad,1,0,'C',1);
        $pdf->Cell(20,4,number_format($precio_total),1,0,'R',1);
        $pdf->Cell(10,4,number_format($comd_iva,0),1,0,'R',1);
        $pdf->Cell(15,4,number_format($iva,0),1,0,'R',1);
        $pdf->Cell(15,4,number_format($cargo_adicional,0),1,0,'R',1);
        $pdf->Cell(20,4,number_format($precio_total+$iva,0),1,0,'R',1);
        $pdf->Ln();
    }
    $cargo_global+=$total_cargo_adicional;
    $iva_global+=$total_iva;


    $pdf->SetFillColor(239,215,025);
    $pdf->SetFont('Arial','B',7);
    $pdf->Cell(95,4,'',1,0,'C',1);
    $pdf->Cell(15,4,'TOTAL',1,0,'C',1);
    $pdf->Cell(20,4,number_format($sumador_articulos,0),1,0,'R',1);
    $pdf->Cell(10,4,'',1,0,'R',1);
    $pdf->Cell(15,4,number_format($iva_global,0),1,0,'R',1);
    $pdf->Cell(15,4,number_format($cargo_global,0),1,0,'R',1);
    $pdf->Cell(20,4,number_format($sumador_articulos+$total_iva+$cargo_global,0),1,0,'R',1);
    $pdf->Ln();
    $pdf->Ln();

}



  
   
    $pdf->Ln(); 
        
$pdf->Output();
?>