<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:F1')->mergeCells('A2:F2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:H2', 'BDBDBD'); 
cellColor('A1:H1', 'BDBDBD'); 
cellColor('A3:H3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE VALOR INVENTARIO')
            ->setCellValue('A2', '')
            ->setCellValue('A3', 'CODIGO')
            ->setCellValue('B3', 'NOMBRE')
            ->setCellValue('C3', 'COSTO U')
            ->setCellValue('D3', 'IVA')
            ->setCellValue('E3', 'FAMILIA')
            ->setCellValue('F3', 'PROVEEDOR')
            ->setCellValue('G3', 'GARANTIA')
            ->setCellValue('H3', 'GENERAL');

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(15);   
$sheet->getColumnDimension('B')->setWidth(20);  
$sheet->getColumnDimension('C')->setWidth(20); 
$sheet->getColumnDimension('D')->setWidth(20); 
$sheet->getColumnDimension('E')->setWidth(20); 
$sheet->getColumnDimension('F')->setWidth(20); 
$sheet->getColumnDimension('G')->setWidth(20); 
$sheet->getColumnDimension('H')->setWidth(20); 

$cel=4;//Numero de fila donde empezara a crear  el reporte


$sumador_total_costo=0; 
$sumador_total_venta=0; 
$query=mysqli_query($con, "SELECT * from articulos a, articulos_has_bodegas ab where a.art_id=ab.articulos_art_id and ab.bodegas='$bod_id' AND ab.sucursal='$sucursal' and a.empresa='$empresa' and a.art_tipo='articulo' group by a.art_id order by a.art_referencia asc ");

while ($row=mysqli_fetch_array($query))    
{
    $art_id=$row['art_id'];
    $art_referencia=$row['art_referencia'];
    $art_nombre=$row['art_nombre'];
    $art_precio_costo=$row['art_precio_costo'];
    $art_garantia=$row['art_garantia'];
    $art_iva=$row['art_iva'];
    $art_pvp=$row['art_pvp'];

    $proveedor_pro_id=$row['proveedor_pro_id'];
    $sql2=mysqli_query($con, "SELECT * from proveedor where pro_id='$proveedor_pro_id'");
    $c=mysqli_fetch_array($sql2);
    $pro_nombre=$c['pro_nombre'];

    $familias_fam_id=$row['familias_fam_id'];
    $sql2f=mysqli_query($con, "SELECT * from familias where fam_id='$familias_fam_id'");
    $cf=mysqli_fetch_array($sql2f);
    $fam_nombre=$cf['fam_nombre'];

  

    
        $a="A".$cel;
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
        $e="E".$cel;
        $f="F".$cel;
        $g="G".$cel;
        $h="H".$cel;
           
        // Agregar datos
        $sheet
        ->setCellValue($a, $art_referencia)
        ->setCellValue($b, $art_nombre)
        ->setCellValue($c, $art_precio_costo)
        ->setCellValue($d, $art_iva)
        ->setCellValue($e, $fam_nombre)
        ->setCellValue($f, $pro_nombre)
        ->setCellValue($g, $art_garantia)
        ->setCellValue($h, $art_pvp);
        
        $cel+=1;

      
}
   


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE VALOR INVENTARIO.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>