<?php
session_start();
include "../conexion.php";
require_once('../include/sesiones.php'); 
$trad_id=$_GET['id'];   
$can=mysqli_query($con,"SELECT * from trasladoe_detalle where trad_id='$trad_id' and empresa='$empresa'") or die(mysqli_error($con)); 
$dato=mysqli_fetch_array($can);

$trad_art_id=$dato['trad_art_id'];
$trad_nombre=$dato['trad_nombre'];
$trad_cantidad=$dato['trad_cantidad'];
$trad_referencia=$dato['trad_referencia'];
$trasladoe_tra_id=$dato['trasladoe_tra_id'];

// CONTAR LOS SERIALES
$can_seriales = mysqli_query($con, "SELECT COUNT(*) as total_seriales FROM serial_trasladoe WHERE trasladoe_detalle_trad_id='$trad_id'") or die(mysqli_error($con));
$dat_seriales = mysqli_fetch_assoc($can_seriales);
$total_seriales = intval($dat_seriales['total_seriales']);

// VALIDAR COINCIDENCIA
$coinciden = ($trad_cantidad == $total_seriales);
?>

<form role="form" id="actualizar"> 
    <div id="resultados_modi"></div>      
    <div class="row" style="padding: 10px;">
        <div class="col-md-6">
            <label for="codigo_item" class="control-label">Código</label>
            <input type="text" class="form-control" id="codigo_item" name="codigo_item" value="<?php echo $trad_referencia; ?>" disabled required>
            <input type="hidden" name="id" value="<?php echo $trad_id; ?>">
            <input type="hidden" name="art_id" value="<?php echo $trad_art_id; ?>">
        </div>
        <div class="col-md-6">
            <label for="cantidad_item" class="control-label">Cantidad</label>
            <input type="number" class="form-control" value="<?php echo $trad_cantidad; ?>" min='1' name="cantidad" id="cantidad" required>
        </div>

        <div class="">
            <label for="art_nombre" class="control-label">Descripción</label>
            <textarea class="form-control" name="art_nombre" id="art_nombre" disabled><?php echo $trad_nombre; ?></textarea>
        </div>
    </div>

    <!-- Mensaje si no coinciden -->
    <?php if (!$coinciden): ?>
        <div class="alert alert-danger text-center" id="alerta-cantidad" style="<?php echo $coinciden ? 'display:none;' : ''; ?>">
    ⚠ La cantidad de seriales (<strong id="alerta-seriales"><?php echo $total_seriales; ?></strong>) 
    no coincide con la cantidad de artículos (<strong id="alerta-articulos"><?php echo $trad_cantidad; ?></strong>).<br>
    No puedes modificar hasta que coincidan.
</div>
    <?php endif; ?>

    <ul class="nav nav-tabs">
        <li class="active"><a href="#SERIALES" data-toggle="tab">SERIALES</a></li>
        <li><a href="#OTRO" data-toggle="tab">OTRO</a></li>
    </ul>
    
    <div class="tab-content">
        <!-- SERIALES SELECCIONADOS -->
        <div class="tab-pane active" id="SERIALES">
            <div class="serial-grid">
                <?php
                $can1 = mysqli_query($con, "SELECT * FROM serial_trasladoe WHERE trasladoe_detalle_trad_id='$trad_id'") or die(mysqli_error($con)); 
                while ($roww = mysqli_fetch_array($can1)) {
                    $sert_id = $roww["sert_id"];
                ?>
                <div class="serial-item" id="row-<?php echo $sert_id; ?>">
                    <span class="serial-text"><?php echo $roww['sert_codigo']; ?></span>
                    <a href="#" id="ser-<?php echo $sert_id; ?>" title="Eliminar" class="btn btn-xs btn-danger eliminar-serial"> 
                        <i class="btn-icon-only icon-remove"></i>
                    </a>
                </div>
                <?php } ?>
            </div>
        </div> 

        <!-- OTROS SERIALES DISPONIBLES -->
        <div class="tab-pane" id="OTRO">
            <div class="serial-grid">
            <?php
            $sert_codigos = [];
            $can12 = mysqli_query($con, "SELECT * FROM serial_trasladoe WHERE trasladoe_detalle_trad_id='$trad_id'") or die(mysqli_error($con)); 
            while ($roww2 = mysqli_fetch_array($can12)) { 
                $sert_codigos[] = $roww2["sert_codigo"];
            }

            if (!empty($sert_codigos)) {
                $excluir_codigos = implode(",", array_map(function($codigo) use ($con) {
                    return "'" . mysqli_real_escape_string($con, $codigo) . "'";
                }, $sert_codigos));

                $sql = "SELECT * FROM seriales_articulos 
                        WHERE se_codigo NOT IN ($excluir_codigos) 
                        AND estado='sin vender' 
                        AND articulos_art_id='$trad_art_id'";
            } else {
                $sql = "SELECT * FROM seriales_articulos 
                        WHERE estado='sin vender' 
                        AND articulos_art_id='$trad_art_id'";
            }

            $can123 = mysqli_query($con, $sql) or die(mysqli_error($con)); 

            while ($roww23 = mysqli_fetch_array($can123)) { 
                $se_codigo = $roww23["se_codigo"];
            ?>
                <div class="serial-item">
                    <span class="serial-text"><?php echo $se_codigo; ?></span>
                    <button type="button" class="btn btn-xs btn-success agregar-serial" data-codigo="<?php echo $se_codigo; ?>">
                        <i class="btn-icon-only icon-plus"></i>
                    </button>
                </div>
            <?php } ?>
            </div>
        </div>
    </div>

    <div class="modal-footer">
        <!-- Si no coinciden, deshabilitar el botón de modificar -->
        <button type="submit" id="btn_mod_edi" class="btn btn-success" <?php echo $coinciden ? '' : 'disabled'; ?>>Modificar</button>
    </div>
</form>

<!-- SCRIPT PARA ELIMINAR Y AGREGAR -->
<script>
$(document).ready(function () 
{

    function actualizarEstadoCerrarModal() {
    const coinciden = cantidadSeriales === cantidadArticulos;
   
    }


    // ======== VALIDACIÓN AL ENVIAR =========
    let cantidadArticulos = <?php echo $trad_cantidad; ?>;
    let cantidadSeriales = <?php echo $total_seriales; ?>;

    // ✅ Actualizar cuando el usuario cambia la cantidad
    let alertaMostrada = false;
    function actualizarAlertaCantidad() {
        $("#alerta-seriales").text(cantidadSeriales);
        $("#alerta-articulos").text(cantidadArticulos);

        if (cantidadSeriales !== cantidadArticulos) {
            $("#alerta-cantidad").show();
        } else {
            $("#alerta-cantidad").hide();
        }
    }
    
    $("#cantidad").on("input change", function () {
    cantidadArticulos = parseInt($(this).val()) || 0;
    $("#btn_mod_edi").prop("disabled", cantidadSeriales !== cantidadArticulos);

    actualizarAlertaCantidad(); // 👈 actualiza visualmente el mensaje
    actualizarEstadoCerrarModal();

    if (cantidadSeriales > cantidadArticulos && !alertaMostrada) {
        alert("⚠ Hay más seriales que la cantidad establecida. Elimina seriales para continuar.");
        alertaMostrada = true;
    } else if (cantidadSeriales <= cantidadArticulos) {
        alertaMostrada = false;
    }
    });


    // ========== FUNCIONES ==========

    // Función: Eliminar serial
    function asignarEventosEliminar() {
        $(".eliminar-serial").off().on("click", function (e) {
            e.preventDefault();

            if (!confirm("¿Estás seguro de eliminar?")) return;

            var id = this.id.split('-')[1];
            var codigo = $(this).siblings(".serial-text").text();
            var item = $("#row-" + id);

            $.get("php_traslados_emp/eliminar_serial_tras.php", { sert_id: id }, function (data) {
                if (data.trim() === "ok") {
                    item.fadeOut("fast", function () { $(this).remove(); });
                    cantidadSeriales--; // Restar cantidad
                    actualizarAlertaCantidad();
                    actualizarEstadoCerrarModal();
                    $("#btn_mod_edi").prop("disabled", cantidadSeriales !== cantidadArticulos);

                    $.post("php_traslados_emp/recuperar_serial.php", { codigo: codigo }, function (response) {
                        if (response.trim().startsWith("<div")) {
                            $("#OTRO .serial-grid").append(response);
                            asignarEventosAgregar();
                        } else {
                            console.log("No disponible: " + response);
                        }
                    });
                } else {
                    alert("Error al eliminar: " + data);
                }
            });
        });
    }

    // Función: Agregar serial
    function asignarEventosAgregar() {
        $(".agregar-serial").off().on("click", function () {
            // ⚠️ Validar antes de agregar
            if (cantidadSeriales >= cantidadArticulos) {
                alert("⚠ No puedes agregar más seriales de los que indica la cantidad de artículos.");
                return; // 🚫 No hace nada más
            }

            var boton = $(this);
            boton.prop("disabled", true);

            var codigo = boton.data("codigo");
            var trad_id = $("input[name='id']").val();

            $.ajax({
                type: "POST",
                url: "php_traslados_emp/agregar_serial.php",
                data: { codigo: codigo, trad_id: trad_id },
                success: function (response) {
                    if (response.trim().startsWith("<div")) {
                        $("#SERIALES .serial-grid").append(response);
                        boton.closest(".serial-item").remove();
                        cantidadSeriales++; // ✅ Sumar cantidad real
                        actualizarAlertaCantidad();
                        actualizarEstadoCerrarModal();
                        $("#btn_mod_edi").prop("disabled", cantidadSeriales !== cantidadArticulos);
                        asignarEventosEliminar();
                    } else {
                        alert("Error: " + response);
                        boton.prop("disabled", false);
                    }
                },
                error: function () {
                    alert("Error al conectar con el servidor.");
                    boton.prop("disabled", false);
                }
            });
        });
    }


    // Función: Enviar formulario principal
    function asignarEventoFormulario() {
        $("#actualizar").submit(function (event) {
            event.preventDefault();
            $('#btn_mod_edi').attr("disabled", true);
            var parametros = $(this).serialize();

            $.ajax({
                type: "POST",
                url: "php_traslados_emp/editar_traslado.php",
                data: parametros,
                beforeSend: function () {
                    $('#resultados_fam').html('<center><img src="./img/ajax-loader.gif"> CARGANDO...</center>');
                },
                success: function (datos) {
                    $("#resultados_modi").html(datos);
                    $('#btn_mod_edi').attr("disabled", false);
                }
            });
        });
    }

    // ========== INICIALIZACIÓN ==========
    asignarEventosEliminar();
    asignarEventosAgregar();
    asignarEventoFormulario();
    actualizarAlertaCantidad();
    actualizarEstadoCerrarModal();
});
</script>


<script>
window.bloquear_modal = <?php echo $coinciden ? 'false' : 'true'; ?>;
</script>

<!-- ESTILOS -->
<style>
.serial-grid {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 10px;
    font-size: 9pt;
}
.serial-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    border: 1px solid #ddd;
    padding: 6px 10px;
    border-radius: 5px;
    background-color: #f9f9f9;
    min-height: 38px;
}
.serial-text {
    font-weight: bold;
    font-size: 12px;
}
.btn-xs.btn-danger,
.btn-xs.btn-success {
    padding: 2px 6px;
    font-size: 10px;
    border-radius: 3px;
}
</style>
