<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:E1')->mergeCells('A2:E2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:E2', 'BDBDBD'); 
cellColor('A1:E1', 'BDBDBD'); 
cellColor('A3:E3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE COMPRAS RETENCIONES')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta)
            ->setCellValue('A3', 'N° COMPRA')
            ->setCellValue('B3', 'PROVEEDOR')
            ->setCellValue('C3', 'BASE')
            ->setCellValue('D3', '% RET')
            ->setCellValue('E3', 'VALOR RETENCIONES');

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(10);   
$sheet->getColumnDimension('B')->setWidth(20);  
$sheet->getColumnDimension('C')->setWidth(20); 
$sheet->getColumnDimension('D')->setWidth(20); 
$sheet->getColumnDimension('E')->setWidth(20);

    $cel=4;//Numero de fila donde empezara a crear  el reporte

$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";

$total_rets=0;
$query=mysqli_query($con, "SELECT * FROM compras c , retencion_compra r where c.com_fecha BETWEEN '$desde' AND '$hasta' and c.sucursal='$sucursal' and c.empresa='$empresa' and r.compras_com_id=c.com_id order by c.com_id desc");


while ($roww=mysqli_fetch_array($query))    
{
    $com_id=$roww['com_id'];
    $sumador_total=0;
    $neto=0;
    $total_retencion=0;

    $sql=mysqli_query($con, "SELECT * from compra_detalle where compras_com_id='$com_id' and empresa='$empresa'");
    while ($rew=mysqli_fetch_array($sql))
    {
        $comd_cantidad=$rew['comd_cantidad'];
        $comd_precio=$rew['comd_precio'];
        $comd_iva=$rew['comd_iva'];
        $precio_total=$comd_precio*$comd_cantidad;
        $iva=($precio_total*$comd_iva)/100;
        $neto+=$precio_total;//Sumador
        $sumador_total+=$precio_total+$iva;//Sumador
    }
        $base=$neto;
        $ret=mysqli_query($con,"SELECT * FROM retencion_compra where empresa='$empresa' and compras_com_id='$com_id'") or die(mysqli_error($con)); 
        $rets=mysqli_fetch_array($ret);
        $total_retencion=($ret_porcentaje=$rets['ret_porcentaje']/100)*$neto;
        $total_rets+=$total_retencion;
       
        $a="A".$cel;
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
        $e="E".$cel;
           
        // Agregar datos
        $sheet
        ->setCellValue($a, $roww['com_n_compra'])
        ->setCellValue($b, $roww['proveedor_nombre'])
        ->setCellValue($c, $base)
        ->setCellValue($d, $rets['ret_porcentaje'])
        ->setCellValue($e, $total_retencion);
        
        $cel+=1;

}
    $d="D".$cel;
    $e="E".$cel;

    // Agregar datos
    $sheet->mergeCells("A".($cel).":C".($cel))
    ->setCellValue($d, 'TOTAL GENERAL')
    ->setCellValue($e,  $total_rets);


    cellColor('A'.$cel.':E'.$cel, 'BDBDBD');

// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE COMPRAS RETENCIONES.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>